<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/vision/v1/product_search_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Vision\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Vision\V1\AddProductToProductSetRequest;
use Google\Cloud\Vision\V1\BatchOperationMetadata;
use Google\Cloud\Vision\V1\CreateProductRequest;
use Google\Cloud\Vision\V1\CreateProductSetRequest;
use Google\Cloud\Vision\V1\CreateReferenceImageRequest;
use Google\Cloud\Vision\V1\DeleteProductRequest;
use Google\Cloud\Vision\V1\DeleteProductSetRequest;
use Google\Cloud\Vision\V1\DeleteReferenceImageRequest;
use Google\Cloud\Vision\V1\GetProductRequest;
use Google\Cloud\Vision\V1\GetProductSetRequest;
use Google\Cloud\Vision\V1\GetReferenceImageRequest;
use Google\Cloud\Vision\V1\ImportProductSetsRequest;
use Google\Cloud\Vision\V1\ImportProductSetsResponse;
use Google\Cloud\Vision\V1\ListProductSetsRequest;
use Google\Cloud\Vision\V1\ListProductsInProductSetRequest;
use Google\Cloud\Vision\V1\ListProductsRequest;
use Google\Cloud\Vision\V1\ListReferenceImagesRequest;
use Google\Cloud\Vision\V1\Product;
use Google\Cloud\Vision\V1\ProductSet;
use Google\Cloud\Vision\V1\PurgeProductsRequest;
use Google\Cloud\Vision\V1\ReferenceImage;
use Google\Cloud\Vision\V1\RemoveProductFromProductSetRequest;
use Google\Cloud\Vision\V1\UpdateProductRequest;
use Google\Cloud\Vision\V1\UpdateProductSetRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Manages Products and ProductSets of reference images for use in product
 * search. It uses the following resource model:
 *
 * - The API has a collection of [ProductSet][google.cloud.vision.v1.ProductSet]
 * resources, named `projects/&#42;/locations/&#42;/productSets/*`, which acts as a way
 * to put different products into groups to limit identification.
 *
 * In parallel,
 *
 * - The API has a collection of [Product][google.cloud.vision.v1.Product]
 * resources, named
 * `projects/&#42;/locations/&#42;/products/*`
 *
 * - Each [Product][google.cloud.vision.v1.Product] has a collection of
 * [ReferenceImage][google.cloud.vision.v1.ReferenceImage] resources, named
 * `projects/&#42;/locations/&#42;/products/&#42;/referenceImages/*`
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<void> addProductToProductSetAsync(AddProductToProductSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Product> createProductAsync(CreateProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProductSet> createProductSetAsync(CreateProductSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReferenceImage> createReferenceImageAsync(CreateReferenceImageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteProductAsync(DeleteProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteProductSetAsync(DeleteProductSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteReferenceImageAsync(DeleteReferenceImageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Product> getProductAsync(GetProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProductSet> getProductSetAsync(GetProductSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReferenceImage> getReferenceImageAsync(GetReferenceImageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importProductSetsAsync(ImportProductSetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProductSetsAsync(ListProductSetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProductsAsync(ListProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProductsInProductSetAsync(ListProductsInProductSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReferenceImagesAsync(ListReferenceImagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> purgeProductsAsync(PurgeProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> removeProductFromProductSetAsync(RemoveProductFromProductSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Product> updateProductAsync(UpdateProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProductSet> updateProductSetAsync(UpdateProductSetRequest $request, array $optionalArgs = [])
 */
final class ProductSearchClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.vision.v1.ProductSearch';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'vision.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'vision.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-vision',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/product_search_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/product_search_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/product_search_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/product_search_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a product
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $product
     *
     * @return string The formatted product resource.
     */
    public static function productName(string $project, string $location, string $product): string
    {
        return self::getPathTemplate('product')->render([
            'project' => $project,
            'location' => $location,
            'product' => $product,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a product_set
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $productSet
     *
     * @return string The formatted product_set resource.
     */
    public static function productSetName(string $project, string $location, string $productSet): string
    {
        return self::getPathTemplate('productSet')->render([
            'project' => $project,
            'location' => $location,
            'product_set' => $productSet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * reference_image resource.
     *
     * @param string $project
     * @param string $location
     * @param string $product
     * @param string $referenceImage
     *
     * @return string The formatted reference_image resource.
     */
    public static function referenceImageName(string $project, string $location, string $product, string $referenceImage): string
    {
        return self::getPathTemplate('referenceImage')->render([
            'project' => $project,
            'location' => $location,
            'product' => $product,
            'reference_image' => $referenceImage,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - product: projects/{project}/locations/{location}/products/{product}
     * - productSet: projects/{project}/locations/{location}/productSets/{product_set}
     * - referenceImage: projects/{project}/locations/{location}/products/{product}/referenceImages/{reference_image}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'vision.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds a Product to the specified ProductSet. If the Product is already
     * present, no change is made.
     *
     * One Product can be added to at most 100 ProductSets.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the Product or the ProductSet doesn't exist.
     *
     * The async variant is {@see ProductSearchClient::addProductToProductSetAsync()} .
     *
     * @example samples/V1/ProductSearchClient/add_product_to_product_set.php
     *
     * @param AddProductToProductSetRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addProductToProductSet(AddProductToProductSetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('AddProductToProductSet', $request, $callOptions)->wait();
    }

    /**
     * Creates and returns a new product resource.
     *
     * Possible errors:
     *
     * * Returns INVALID_ARGUMENT if display_name is missing or longer than 4096
     * characters.
     * * Returns INVALID_ARGUMENT if description is longer than 4096 characters.
     * * Returns INVALID_ARGUMENT if product_category is missing or invalid.
     *
     * The async variant is {@see ProductSearchClient::createProductAsync()} .
     *
     * @example samples/V1/ProductSearchClient/create_product.php
     *
     * @param CreateProductRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Product
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createProduct(CreateProductRequest $request, array $callOptions = []): Product
    {
        return $this->startApiCall('CreateProduct', $request, $callOptions)->wait();
    }

    /**
     * Creates and returns a new ProductSet resource.
     *
     * Possible errors:
     *
     * * Returns INVALID_ARGUMENT if display_name is missing, or is longer than
     * 4096 characters.
     *
     * The async variant is {@see ProductSearchClient::createProductSetAsync()} .
     *
     * @example samples/V1/ProductSearchClient/create_product_set.php
     *
     * @param CreateProductSetRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProductSet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createProductSet(CreateProductSetRequest $request, array $callOptions = []): ProductSet
    {
        return $this->startApiCall('CreateProductSet', $request, $callOptions)->wait();
    }

    /**
     * Creates and returns a new ReferenceImage resource.
     *
     * The `bounding_poly` field is optional. If `bounding_poly` is not specified,
     * the system will try to detect regions of interest in the image that are
     * compatible with the product_category on the parent product. If it is
     * specified, detection is ALWAYS skipped. The system converts polygons into
     * non-rotated rectangles.
     *
     * Note that the pipeline will resize the image if the image resolution is too
     * large to process (above 50MP).
     *
     * Possible errors:
     *
     * * Returns INVALID_ARGUMENT if the image_uri is missing or longer than 4096
     * characters.
     * * Returns INVALID_ARGUMENT if the product does not exist.
     * * Returns INVALID_ARGUMENT if bounding_poly is not provided, and nothing
     * compatible with the parent product's product_category is detected.
     * * Returns INVALID_ARGUMENT if bounding_poly contains more than 10 polygons.
     *
     * The async variant is {@see ProductSearchClient::createReferenceImageAsync()} .
     *
     * @example samples/V1/ProductSearchClient/create_reference_image.php
     *
     * @param CreateReferenceImageRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReferenceImage
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createReferenceImage(CreateReferenceImageRequest $request, array $callOptions = []): ReferenceImage
    {
        return $this->startApiCall('CreateReferenceImage', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes a product and its reference images.
     *
     * Metadata of the product and all its images will be deleted right away, but
     * search queries against ProductSets containing the product may still work
     * until all related caches are refreshed.
     *
     * The async variant is {@see ProductSearchClient::deleteProductAsync()} .
     *
     * @example samples/V1/ProductSearchClient/delete_product.php
     *
     * @param DeleteProductRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteProduct(DeleteProductRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteProduct', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes a ProductSet. Products and ReferenceImages in the
     * ProductSet are not deleted.
     *
     * The actual image files are not deleted from Google Cloud Storage.
     *
     * The async variant is {@see ProductSearchClient::deleteProductSetAsync()} .
     *
     * @example samples/V1/ProductSearchClient/delete_product_set.php
     *
     * @param DeleteProductSetRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteProductSet(DeleteProductSetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteProductSet', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes a reference image.
     *
     * The image metadata will be deleted right away, but search queries
     * against ProductSets containing the image may still work until all related
     * caches are refreshed.
     *
     * The actual image files are not deleted from Google Cloud Storage.
     *
     * The async variant is {@see ProductSearchClient::deleteReferenceImageAsync()} .
     *
     * @example samples/V1/ProductSearchClient/delete_reference_image.php
     *
     * @param DeleteReferenceImageRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteReferenceImage(DeleteReferenceImageRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteReferenceImage', $request, $callOptions)->wait();
    }

    /**
     * Gets information associated with a Product.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the Product does not exist.
     *
     * The async variant is {@see ProductSearchClient::getProductAsync()} .
     *
     * @example samples/V1/ProductSearchClient/get_product.php
     *
     * @param GetProductRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Product
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProduct(GetProductRequest $request, array $callOptions = []): Product
    {
        return $this->startApiCall('GetProduct', $request, $callOptions)->wait();
    }

    /**
     * Gets information associated with a ProductSet.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the ProductSet does not exist.
     *
     * The async variant is {@see ProductSearchClient::getProductSetAsync()} .
     *
     * @example samples/V1/ProductSearchClient/get_product_set.php
     *
     * @param GetProductSetRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProductSet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProductSet(GetProductSetRequest $request, array $callOptions = []): ProductSet
    {
        return $this->startApiCall('GetProductSet', $request, $callOptions)->wait();
    }

    /**
     * Gets information associated with a ReferenceImage.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the specified image does not exist.
     *
     * The async variant is {@see ProductSearchClient::getReferenceImageAsync()} .
     *
     * @example samples/V1/ProductSearchClient/get_reference_image.php
     *
     * @param GetReferenceImageRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReferenceImage
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getReferenceImage(GetReferenceImageRequest $request, array $callOptions = []): ReferenceImage
    {
        return $this->startApiCall('GetReferenceImage', $request, $callOptions)->wait();
    }

    /**
     * Asynchronous API that imports a list of reference images to specified
     * product sets based on a list of image information.
     *
     * The [google.longrunning.Operation][google.longrunning.Operation] API can be
     * used to keep track of the progress and results of the request.
     * `Operation.metadata` contains `BatchOperationMetadata`. (progress)
     * `Operation.response` contains `ImportProductSetsResponse`. (results)
     *
     * The input source of this method is a csv file on Google Cloud Storage.
     * For the format of the csv file please see
     * [ImportProductSetsGcsSource.csv_file_uri][google.cloud.vision.v1.ImportProductSetsGcsSource.csv_file_uri].
     *
     * The async variant is {@see ProductSearchClient::importProductSetsAsync()} .
     *
     * @example samples/V1/ProductSearchClient/import_product_sets.php
     *
     * @param ImportProductSetsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importProductSets(ImportProductSetsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportProductSets', $request, $callOptions)->wait();
    }

    /**
     * Lists ProductSets in an unspecified order.
     *
     * Possible errors:
     *
     * * Returns INVALID_ARGUMENT if page_size is greater than 100, or less
     * than 1.
     *
     * The async variant is {@see ProductSearchClient::listProductSetsAsync()} .
     *
     * @example samples/V1/ProductSearchClient/list_product_sets.php
     *
     * @param ListProductSetsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProductSets(ListProductSetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProductSets', $request, $callOptions);
    }

    /**
     * Lists products in an unspecified order.
     *
     * Possible errors:
     *
     * * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
     *
     * The async variant is {@see ProductSearchClient::listProductsAsync()} .
     *
     * @example samples/V1/ProductSearchClient/list_products.php
     *
     * @param ListProductsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProducts(ListProductsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProducts', $request, $callOptions);
    }

    /**
     * Lists the Products in a ProductSet, in an unspecified order. If the
     * ProductSet does not exist, the products field of the response will be
     * empty.
     *
     * Possible errors:
     *
     * * Returns INVALID_ARGUMENT if page_size is greater than 100 or less than 1.
     *
     * The async variant is {@see ProductSearchClient::listProductsInProductSetAsync()}
     * .
     *
     * @example samples/V1/ProductSearchClient/list_products_in_product_set.php
     *
     * @param ListProductsInProductSetRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProductsInProductSet(ListProductsInProductSetRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProductsInProductSet', $request, $callOptions);
    }

    /**
     * Lists reference images.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the parent product does not exist.
     * * Returns INVALID_ARGUMENT if the page_size is greater than 100, or less
     * than 1.
     *
     * The async variant is {@see ProductSearchClient::listReferenceImagesAsync()} .
     *
     * @example samples/V1/ProductSearchClient/list_reference_images.php
     *
     * @param ListReferenceImagesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReferenceImages(ListReferenceImagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReferenceImages', $request, $callOptions);
    }

    /**
     * Asynchronous API to delete all Products in a ProductSet or all Products
     * that are in no ProductSet.
     *
     * If a Product is a member of the specified ProductSet in addition to other
     * ProductSets, the Product will still be deleted.
     *
     * It is recommended to not delete the specified ProductSet until after this
     * operation has completed. It is also recommended to not add any of the
     * Products involved in the batch delete to a new ProductSet while this
     * operation is running because those Products may still end up deleted.
     *
     * It's not possible to undo the PurgeProducts operation. Therefore, it is
     * recommended to keep the csv files used in ImportProductSets (if that was
     * how you originally built the Product Set) before starting PurgeProducts, in
     * case you need to re-import the data after deletion.
     *
     * If the plan is to purge all of the Products from a ProductSet and then
     * re-use the empty ProductSet to re-import new Products into the empty
     * ProductSet, you must wait until the PurgeProducts operation has finished
     * for that ProductSet.
     *
     * The [google.longrunning.Operation][google.longrunning.Operation] API can be
     * used to keep track of the progress and results of the request.
     * `Operation.metadata` contains `BatchOperationMetadata`. (progress)
     *
     * The async variant is {@see ProductSearchClient::purgeProductsAsync()} .
     *
     * @example samples/V1/ProductSearchClient/purge_products.php
     *
     * @param PurgeProductsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function purgeProducts(PurgeProductsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PurgeProducts', $request, $callOptions)->wait();
    }

    /**
     * Removes a Product from the specified ProductSet.
     *
     * The async variant is
     * {@see ProductSearchClient::removeProductFromProductSetAsync()} .
     *
     * @example samples/V1/ProductSearchClient/remove_product_from_product_set.php
     *
     * @param RemoveProductFromProductSetRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeProductFromProductSet(RemoveProductFromProductSetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('RemoveProductFromProductSet', $request, $callOptions)->wait();
    }

    /**
     * Makes changes to a Product resource.
     * Only the `display_name`, `description`, and `labels` fields can be updated
     * right now.
     *
     * If labels are updated, the change will not be reflected in queries until
     * the next index time.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the Product does not exist.
     * * Returns INVALID_ARGUMENT if display_name is present in update_mask but is
     * missing from the request or longer than 4096 characters.
     * * Returns INVALID_ARGUMENT if description is present in update_mask but is
     * longer than 4096 characters.
     * * Returns INVALID_ARGUMENT if product_category is present in update_mask.
     *
     * The async variant is {@see ProductSearchClient::updateProductAsync()} .
     *
     * @example samples/V1/ProductSearchClient/update_product.php
     *
     * @param UpdateProductRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Product
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateProduct(UpdateProductRequest $request, array $callOptions = []): Product
    {
        return $this->startApiCall('UpdateProduct', $request, $callOptions)->wait();
    }

    /**
     * Makes changes to a ProductSet resource.
     * Only display_name can be updated currently.
     *
     * Possible errors:
     *
     * * Returns NOT_FOUND if the ProductSet does not exist.
     * * Returns INVALID_ARGUMENT if display_name is present in update_mask but
     * missing from the request or longer than 4096 characters.
     *
     * The async variant is {@see ProductSearchClient::updateProductSetAsync()} .
     *
     * @example samples/V1/ProductSearchClient/update_product_set.php
     *
     * @param UpdateProductSetRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProductSet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateProductSet(UpdateProductSetRequest $request, array $callOptions = []): ProductSet
    {
        return $this->startApiCall('UpdateProductSet', $request, $callOptions)->wait();
    }
}
